<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Hash;

class AdminsController extends Controller {

    public function index(Request $request) {
        $user = auth()->user();
        return view('admin.profile', ['user' => $user, 'title' => "PROFILE"]);
    }

    public function editProfile(Request $request) {
        if(App::environment("demo")) {
            return redirect(route('profile'));
        }

        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
        ]);

        $user = User::where('id', auth()->user()->id)->first();
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->save();

        return redirect(route('profile'));
    }

    public function editSecurity(Request $request) {
        if(App::environment("demo")) {
            return redirect(route('profile'));
        }

        $request->validate([
            'password' => 'required|confirmed|min:6',
        ]);

        $user = User::where('id', auth()->user()->id)->first();
        $user->password = Hash::make($request->input('password'));
        $user->save();

        return redirect(route('profile'));
    }
}
