<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Storage;

class ConfigsController extends Controller {
   public function index(Request $request) {
      $androidConfig = "";
      if (Storage::disk('local')->exists('android_config.txt')) {
         $androidConfig = Storage::disk('local')->get('android_config.txt');
      }

      return view('admin.config', [
         'title' => "CONFIGURATION",
         'android_config' => $androidConfig
      ]);
   }

   public function deleteAndroidConfig(Request $request) {
      if (App::environment("demo")) {
         return true;
      }

      if (Storage::disk('local')->exists('android_config.txt')) {
         Storage::disk('local')->delete('android_config.txt');
         return true;
      }
      return false;
   }

   public function downloadInstallFiles(Request $request) {
      $file = storage_path("app/public/") . "install.zip";
      if (file_exists($file)) {
         return response()->download($file);
      }
      abort(404);
   }
}
