<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ConnectedDevice;
use App\Models\Server;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ConnectedDevicesController extends Controller {

    public function resetOldDevices() {
        $days = Setting::where('key', 'older_than_days')->first()->value;
        $servers = Server::all();
        $total = 0;
        foreach ($servers as $server) {
            $affected = ConnectedDevice::whereNull('disconnect_time')
                ->where('created_at', '<', Carbon::now()->subDays($days))
                ->where('server_id', $server->id)
                ->update(['disconnect_time' => Carbon::now()]);
            $newCount = $server->connected_devices - $affected;

            if ($newCount >= 0) {
                $server->connected_devices = $newCount;
                $server->save();
            }
            $total = $total + $affected;
        }

        return response(['result' => true, 'count' => $total]);
    }
}
