<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Server;
use App\Models\Setting;
use Illuminate\Support\Facades\DB;
use Locale;
use stdClass;

class DashboardController extends Controller {

    public function index() {
        $data = Setting::pluck('value', 'key');
        // $data['servers'] = Server::count();
        $data['servers'] = DB::select("SELECT
            (SELECT COUNT(id) FROM servers) AS total,
            (SELECT COUNT(id) FROM servers WHERE is_enabled=1) AS enabled")[0];
        $data['connected'] = Server::sum('connected_devices');

        $data['country_stats'] = DB::select(
            "SELECT country_code, connect_count, 100*connect_count/total.s AS percent
            FROM countries_stats CROSS JOIN (SELECT SUM(connect_count) AS s FROM countries_stats) AS total
            ORDER BY connect_count DESC"
        );

        $truncatedData = [];
        $pieChartColors = ['#E91E63', '#03A9F4', '#FFC107', '#009688', '#dd9688'];

        for ($i = 0; $i < count($data['country_stats']); $i++) {
            if ($i < 4) {
                $truncatedData[$i] = new stdClass();
                $truncatedData[$i]->color = $pieChartColors[$i];
                $truncatedData[$i]->label = Locale::getDisplayRegion("-" . $data['country_stats'][$i]->country_code, 'en');
                $truncatedData[$i]->data = (float) $data['country_stats'][$i]->percent;
            } else if ($i == 4) {
                $truncatedData[$i] = new stdClass();
                $truncatedData[$i]->label = "Others";
                $truncatedData[$i]->color = $pieChartColors[4];
                $truncatedData[$i]->data = (float) $data['country_stats'][4]->percent;
            } else {
                $truncatedData[4]->data += $data['country_stats'][$i]->percent;
            }
        }
        // dd($truncatedData);
        $data['truncated_data'] = json_encode($truncatedData);

        return view('admin.dashboard', ['data' => $data, 'index' => 1, 'title' => "DASHBOARD"]);
    }
}
