<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class SettingsController extends Controller {
    public function index(Request $request) {
        $data = Setting::pluck('value', 'key');
        //cannot uncheck allow_duplicate_ips if there are already duplicate servers
        return view('admin.settings', ['data' => $data, 'title' => "SETTINGS"]);
    }

    public function store(Request $request) {
        if (App::environment("demo")) {
            return redirect()->back();
        }

        $data = $request->all();
        unset($data['_token']);
        $data['allow_duplicate_ips'] = $request->input('allow_duplicate_ips') ? 1 : 0;
        $data['track_connections'] = $request->input('track_connections') ? 1 : 0;
        Setting::insertOrUpdate($data);
        return redirect()->back();
    }
}
