<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\ConnectedDevice;
use App\Models\CountryStats;
use App\Models\Server;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ConnectedDevicesController extends Controller {

    public function getIP(Request $request) {
        return response()->json([
            'key' => "ip",
            'value' => get_ip(),
        ]);
    }

    public function logConnect(Request $request) {
        $request->validate([
            'server_id' => 'required',
            'device_id' => 'required',
            'ip' => 'required',
        ]);

        $serverId = $request->input('server_id');
        Server::where('id', $serverId)->increment('connected_devices');

        $isAuto = $request->input('is_auto', "true");

        //stats are only for countries choisen manually
        if ($isAuto === "false") {
            $server = Server::find($serverId);
            if ($server == null) {
                return response(false);
            }
            $stat = CountryStats::firstOrCreate(['country_code' => $server->country_code]);
            $stat->country_code = $server->country_code;
            $stat->connect_count++;
            $stat->save();
        }

        $trackConnection = Setting::get('track_connections', '0');
        if ($trackConnection == 0)
            return response(false);

        $device = new ConnectedDevice();
        $device->server_id = $serverId;
        $device->device_id = $request->input('device_id');
        $device->ip = $request->input('ip');

        //disconnect all previous connections
        ConnectedDevice::where('device_id', $device->device_id)
            ->whereNull('disconnect_time')
            ->update(['disconnect_time' => Carbon::now()]);

        $device->save();

        return response(true);
    }

    public function logDisconnect(Request $request) {
        $request->validate([
            'server_id' => 'required',
            'device_id' => 'required',
        ]);

        $serverId = $request->input('server_id');
        $server = Server::where('id', $serverId)->first();
        if (!$server)
            return response(false);

        if ($server->connected_devices > 0) {
            $server->connected_devices = $server->connected_devices - 1;
            $server->save();
        }

        $trackConnection = Setting::get('track_connection', '0');
        if ($trackConnection == 0)
            return response(false);

        $deviceId = $request->input('device_id');
        ConnectedDevice::where('device_id', $deviceId)
            ->whereNull('disconnect_time')
            ->update(['disconnect_time' => Carbon::now()]);
        return response(true);
    }
}
