<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ServersController extends Controller {

    public function all(Request $request) {
        $servers = DB::select(
            "SELECT s.id, s.country_code, s.city, s.ip, s.protocol, s.port, s.vpn_username, s.vpn_password, is_free, s.order, s.use_file, s.free_connect_duration, connected_devices
            FROM servers AS s WHERE s.is_enabled=1
            ORDER BY `order` ASC"
        );
        return response()->json($servers);
    }

    public function best(Request $request) {
        $subscribed = $request->input('s') == 1; //not subscribed by default

        if ($subscribed) {
            $servers = DB::select(
                "SELECT s.id FROM servers AS s WHERE s.is_enabled=1 ORDER BY connected_devices ASC LIMIT 1"
            );
        } else {
            $servers = DB::select(
                "SELECT s.id FROM servers AS s WHERE s.is_enabled=1 AND is_free=1 ORDER BY connected_devices ASC LIMIT 1"
            );
        }

        return $servers[0]->id;
    }

    public function download(Request $request) {
        $request->validate([
            'id' => 'required|numeric|min:0',
        ]);

        $id = $request->input('id');
        $file = storage_path('app/public/uploaded_ovpn_files/') . "$id.ovpn";

        if (file_exists($file)) {
            return response()->download($file);
        }
        abort(404);
    }
}
