<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsController extends Controller {

    public function get(Request $request) {
        $key = $request->input('key');
        $value = Setting::get($key);
        return response()->json([
            'key' => $key,
            'value' => $value,
        ]);
    }

    public function getAdIds() {
        $data = [
            'ao' => Setting::get('admob_appopen_id'),
            'aab' => Setting::get('admob_allowed_apps_banner_id'),
            'sb' => Setting::get('admob_servers_banner_id'),
            'ci' => Setting::get('admob_connect_inter_id'),
            'ni' => Setting::get('admob_inter_id'),
            'mti' => Setting::get('admob_more_time_inter_id'),
            'mtri' => Setting::get('admob_more_time_reward_inter_id'),
            'mtr' => Setting::get('admob_more_time_reward_id'),
            'mn' => Setting::get('admob_native_id'),
        ];

        return response()->json($data);
    }
}
