<?php

namespace App\Http\Middleware;

use Closure;
use Exception;
use Illuminate\Http\Request;
use phpseclib3\Crypt\PublicKeyLoader;
use phpseclib3\Crypt\RSA;

class ApiAccess {
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next) {
        if (env('RESTRICT_API') == false) {
            return $next($request);
        }

        if ($request->header("Authorization") !== env("API_KEY") || $request->header("User-Agent") !== "OVPN") {
            abort(403);
        }

        try {
            $key = PublicKeyLoader::load(file_get_contents(storage_path('app/prk.pem')))->withPadding(RSA::ENCRYPTION_PKCS1);
            $dec = $key->decrypt(base64_decode(urldecode($request->input('t', ""))));
        } catch(Exception $e) {
            abort(403);
        }

        if (!is_numeric($dec) || ($dec + 0)/1000 + 10 < time()) {
            abort(403);
        }

        return $next($request);
    }
}
