<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Kreait\Firebase\Messaging\Notification as FirebaseNotification;

class Notification extends Model
{
    use HasFactory;

    public function createFirebaseNotification() {
        return FirebaseNotification::create($this->title, $this->body);
    }

    public function createFirebaseNotificationAsData() {
      return [
          'title' => $this->title,
          'body' => $this->body,
          'type' => 'notification'
      ];
  }
}
