<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Setting;

class Server extends Model {
    use HasFactory;

    protected $hidden = ['created_at', 'updated_at'];
    protected $casts = [
        'is_enabled' => 'boolean',
        'is_free' => 'boolean',
        'use_file' => 'boolean',
        'warn_when_unavailable' => 'boolean',
        'auto_disable' => 'boolean',
    ];

    public function save(array $options = []) {
        parent::save($options);
        Setting::insertOrUpdate(['last_update' => Carbon::now()]);
    }

    public function delete() {
        parent::delete();
        Setting::insertOrUpdate(['last_update' => Carbon::now()]);
    }
}
