<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('config_server_actions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('config_job_id')->nullable()->index('config_server_actions_config_job_id_foreign');
            $table->unsignedInteger('order')->default(0);
            $table->text('action');
            $table->integer('result_code')->default(-1);
            $table->text('result');
            $table->timestamps();
        });

        Schema::create('config_server_jobs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('job_id')->nullable()->index('config_server_jobs_job_id_foreign');
            $table->unsignedBigInteger('server_id')->nullable()->index('config_server_jobs_server_id_foreign');
            $table->string('country_code', 3);
            $table->string('ip', 50);
            $table->string('vps_username')->default('root');
            $table->string('vps_password')->default('');
            $table->integer('ssh_port')->default(22);
            $table->string('vpn_username')->nullable()->default(null);
            $table->string('vpn_password')->nullable()->default(null);
            $table->integer('vpn_port')->default(1194);
            $table->string('vpn_protocol', 5)->default('udp');
            $table->enum('status', ['idle', 'running', 'stopped', 'success', 'failed'])->default('idle');
            $table->text('message');
            $table->timestamps();
        });

        Schema::create('connected_devices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('device_id');
            $table->string('ip');
            $table->timestamp('disconnect_time')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('server_id')->index('connected_devices_server_id_foreign');
        });

        Schema::create('countries_stats', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('country_code', 3)->unique();
            $table->integer('connect_count')->default(0);
            $table->timestamps();

            $table->index(['country_code'], 'country_code');
        });

        Schema::create('failed_jobs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('uuid')->unique();
            $table->text('connection');
            $table->text('queue');
            $table->longText('payload');
            $table->longText('exception');
            $table->timestamp('failed_at')->useCurrent();
        });

        Schema::create('jobs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('queue')->index();
            $table->longText('payload');
            $table->unsignedTinyInteger('attempts');
            $table->unsignedInteger('reserved_at')->nullable();
            $table->unsignedInteger('available_at');
            $table->unsignedInteger('created_at');
        });

        Schema::create('notifications', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('send_to')->default('all');
            $table->string('topic');
            $table->string('title');
            $table->text('body');
            $table->timestamps();
        });

        Schema::create('password_resets', function (Blueprint $table) {
            $table->string('email')->index();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('servers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->boolean('is_enabled')->default(true);
            $table->string('country_code', 3);
            $table->string('city', 50)->nullable()->default('');
            $table->string('ip', 50);
            $table->string('protocol', 5)->default('udp');
            $table->integer('port')->default(1194);
            $table->string('vpn_username')->default('');
            $table->string('vpn_password')->default('');
            $table->unsignedInteger('connected_devices')->default(0);
            $table->integer('order')->default(0);
            $table->integer('config')->default(0);
            $table->unsignedInteger('free_connect_duration')->default(0)->comment('0 for unlimited');
            $table->integer('min_version_0')->default(0);
            $table->integer('min_version_1')->default(0);
            $table->integer('capacity')->default(100);
            $table->boolean('is_free')->default(true);
            $table->text('service_provider_link');
            $table->boolean('use_file')->default(false);
            $table->integer('warn_when_unavailable')->default(1);
            $table->integer('auto_disable')->default(0);
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        Schema::create('settings', function (Blueprint $table) {
            $table->string('key', 100)->primary();
            $table->string('value');
        });

        Schema::create('traffic_stats', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('server_id')->index('traffic_stats_server_id_foreign');
            $table->string('date', 10);
            $table->unsignedBigInteger('traffic_up');
            $table->unsignedBigInteger('traffic_down');
            $table->timestamps();
        });

        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->boolean('is_admin')->default(false);
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::table('config_server_actions', function (Blueprint $table) {
            $table->foreign(['config_job_id'])->references(['id'])->on('config_server_jobs')->onUpdate('NO ACTION')->onDelete('CASCADE');
        });

        Schema::table('config_server_jobs', function (Blueprint $table) {
            $table->foreign(['job_id'])->references(['id'])->on('jobs')->onUpdate('CASCADE')->onDelete('SET NULL');
            $table->foreign(['server_id'])->references(['id'])->on('servers')->onUpdate('CASCADE')->onDelete('SET NULL');
        });

        Schema::table('traffic_stats', function (Blueprint $table) {
            $table->foreign(['server_id'])->references(['id'])->on('servers')->onUpdate('NO ACTION')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('traffic_stats', function (Blueprint $table) {
            $table->dropForeign('traffic_stats_server_id_foreign');
        });

        Schema::table('config_server_jobs', function (Blueprint $table) {
            $table->dropForeign('config_server_jobs_job_id_foreign');
            $table->dropForeign('config_server_jobs_server_id_foreign');
        });

        Schema::table('config_server_actions', function (Blueprint $table) {
            $table->dropForeign('config_server_actions_config_job_id_foreign');
        });

        Schema::dropIfExists('users');

        Schema::dropIfExists('traffic_stats');

        Schema::dropIfExists('settings');

        Schema::dropIfExists('servers');

        Schema::dropIfExists('password_resets');

        Schema::dropIfExists('notifications');

        Schema::dropIfExists('jobs');

        Schema::dropIfExists('failed_jobs');

        Schema::dropIfExists('countries_stats');

        Schema::dropIfExists('connected_devices');

        Schema::dropIfExists('config_server_jobs');

        Schema::dropIfExists('config_server_actions');
    }
};
