<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder {
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run() {
        DB::table('users')->insert([
            'name' => 'admin',
            'email' => 'admin@ovpn.com',
            'email_verified_at' => Carbon::now(),
            'is_admin' => 1,
            'password' => Hash::make("123456"),
        ]);

        DB::table('settings')->insert([
            ['key' => "admob_appopen_id", 'value' => "ca-app-pub-3940256099942544/3419835294"],
            ['key' => "admob_banner_id", 'value' => "ca-app-pub-3940256099942544/6300978111"],
            ['key' => "admob_inter_id", 'value' => "ca-app-pub-3940256099942544/1033173712"],
            ['key' => "admob_native_id", 'value' => "ca-app-pub-3940256099942544/2247696110"],
            ['key' => "admob_reward_id", 'value' => "ca-app-pub-3940256099942544/5224354917"],
            ['key' => "admob_reward_inter_id", 'value' => "ca-app-pub-3940256099942544/1033173712"],
            ['key' => "allow_duplicate_ips", 'value' => "1"],
            ['key' => "config_server_add_enabled", 'value' => "1"],
            ['key' => "config_server_auto_add", 'value' => "1"],
            ['key' => "config_server_ssh_timeout", 'value' => "20"],
            ['key' => "last_update", 'value' => Carbon::now()],
            ['key' => "older_than_days", 'value' => "3"],
            ['key' => "settings_type", 'value' => "app_settings"],
            ['key' => "track_connections", 'value' => "0"],
            ['key' => "version", 'value' => "30"],
        ]);
    }
}
