@extends('admin.template')

@section('content')
<div class="row clearfix card">
    <div class="body">
        <h2 class="card-inside-title">Notification</h2>
        <form class="p-20" method="post" action="{{route('notifications.send')}}">
            @csrf

            <div class="row clearfix">
                <div class="col-md-2">
                    <div class="form-group {{($errors->first('is_enabled')) ? 'has-error' : ''}}">
                        <label for="topic">Send to (*)</label>
                        <select class="form-control" id="topic" name="topic" required>
                            <option value="all" {{$notification->topic === 'all' ? 'selected' : ''}}>All devices</option>
                            <option value="debug" {{$notification->topic === 'debug' ? 'selected' : ''}}>Test (debug)</option>
                        </select>
                        <span class="text-danger">@error('topic'){{$message}}@enderror</span>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group {{($errors->first('title')) ? 'has-error' : ''}}">
                        <div class="form-line">
                            <label for="title">Title (*)</label>
                            <input type="text" class="form-control" id="title" name="title" value="{{$notification->title}}" required>
                            <span class="text-danger">@error('title'){{$message}}@enderror</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group form-float">
                <div class="form-line">
                    <textarea id="body" name="body" rows="5" class="form-control no-resize" aria-required="true" required>{{$notification->body}}</textarea>
                    <label for="body" class="form-label">Body (*)</label>
                    <span class="text-danger">@error('body'){{$message}}@enderror</span>
                </div>
            </div>

            <button type="submit" name="submit" value="" class="btn bg-green waves-effect"><i class="material-icons">save</i><span>Send</span></button>
        </form>
    </div>
</div>

@endsection
