@extends('admin.template')

@push('scripts')
   <script>
      $(function() {
         $('#status').on('click', function() {
            if ($(this).prop('checked') == true) {
               $(this).attr('checked', true);
               $('#status_text').text("Enabled");
            } else {
               $(this).attr('checked', false);
               $('#status_text').text("Disabled");
            }
         })

         $('#use_default').on('click', function() {
            $('#ovpn_file').attr('required', false);
         });

         $('#use_file').on('click', function() {
            $('#ovpn_file').attr('required', true);
         });

         var countryOption = $('#country_code option[value="{{ strtoupper($server->country_code) }}"]');
         countryOption.attr('selected', 'selected');
         var country = countryOption.text();

         $('button[data-id="country_code"]').attr('title', country);
         $('button[data-id="country_code"] .filter-option').text(country);
         $('.form-line').each(function() {
            $(this).removeClass('focused')
         });
      });
   </script>
   @if ($showSuccess ?? '')
      <script>
         toastr.options = {
            tapToDismiss: true,
            toastClass: 'toast',
            containerId: 'toast-container',
            debug: false,
            fadeIn: 300,
            fadeOut: 500,
            extendedTimeOut: 1000,
            iconClass: 'toast-info',
            positionClass: 'toast-top-right',
            timeOut: 3000,
            titleClass: 'toast-title',
            messageClass: 'toast-message'
         }

         toastr.success('Server added successfully');
      </script>
   @endif
@endpush

@section('content')
   <div class="row clearfix card">
      <form class="p-20" method="post" action="{{ $action }}" enctype='multipart/form-data'>
         @csrf
         @if ($server->id != -1)
            <input type="hidden" name="id" value="{{ $server->id }}">
         @endif

         <div class="header">
            <h2 class="card-inside-title" style="display: inline-block;">General Info</h2>
            <div class="col-md-2 pull-right">
               <div class="switch">
                  <label>
                     <span id="status_text">{{ $server->is_enabled == 1 ? 'Enabled' : 'Disabled' }}</span>
                     <input type="hidden" name="is_enabled" value="0">
                     <input id="status" name="is_enabled" type="checkbox" {{ $server->is_enabled == 1 ? 'checked' : '' }}>
                     <span class="lever switch-col-green"></span>
                  </label>
               </div>
            </div>
         </div>
         <div class="body squize-up">
            <div class="row clearfix">
               <div class="col-md-3">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="country_code">Country (*)</label>
                        <select class="selectpicker countrypicker" data-live-search="true" id="country_code" name="country_code" required></select>
                        <span class="text-danger">
                           @error('country_code')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
               <div class="col-md-2">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="city">City name</label>
                        <input type="text" class="form-control" id="city" name="city" value="{{ $server->city }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-2">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="ip">IP address (*)</label>
                        <input type="text" class="form-control" id="ip" name="ip" value="{{ $server->ip }}" required {{ $server->id == -1 ? '' : 'disabled' }}>
                        <span class="text-danger">
                           @error('ip')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
               <div class="col-md-2">
                  <div class="form-group">
                     <label for="is_free">Availability (*)</label>
                     <select class="form-control" id="is_free" name="is_free">
                        <option value="1" {{ $server->is_free == 1 ? 'selected' : '' }}>Free</option>
                        <option value="0" {{ $server->is_free == 0 ? 'selected' : '' }}>Premium</option>
                     </select>
                     <span class="text-danger">
                        @error('is_free')
                           {{ $message }}
                        @enderror
                     </span>
                  </div>
               </div>
               <div class="col-md-2">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="capacity">Capacity</label>
                        <input type="number" class="form-control" id="capacity" name="capacity" value="{{ $server->capacity }}" min=1>
                        <span class="text-danger">
                           @error('capacity')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
            </div>

            <div class="row clearfix">
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="free_connect_duration">Connect duration (in minutes, 0 for unlimited)</label>
                        <input type="number" class="form-control" id="free_connect_duration" name="free_connect_duration" value="{{ $server->free_connect_duration }}" min=0>
                        <span class="text-danger">
                           @error('free_connect_duration')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
            </div>

            <div class="row clearfix">
               <div class="col-md-3">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="vpn_username">VPN Username</label>
                        <input type="text" class="form-control" id="vpn_username" name="vpn_username" value="{{ $server->vpn_username }}">
                        <span class="text-danger">
                           @error('vpn_username')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
               <div class="col-md-3">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="vpn_password">VPN Password</label>
                        <input type="text" class="form-control" id="vpn_password" name="vpn_password" value="{{ $server->vpn_password }}">
                        <span class="text-danger">
                           @error('vpn_password')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="header">
            <h2 class="card-inside-title">Configuration options</h2>
         </div>
         <div class="body squize-up">
            @if ($server->id == -1)
               <ul class="nav nav-tabs tab-nav-right" role="tablist">
                  <li role="presentation" id="use_default" class="{{ $server->use_file || $errors->has('ovpn_file') ? '' : 'active' }}"><a href="#default" data-toggle="tab">Use default config</a></li>
                  <li role="presentation" id="use_file" class="{{ $server->use_file || $errors->has('ovpn_file') ? 'active' : '' }}"><a href="#custom" data-toggle="tab">Use custom ovpn file</a></li>
               </ul>

               <div class="tab-content">
                  <div role="tabpanel" class="tab-pane fade {{ $server->use_file || $errors->has('ovpn_file') ? '' : 'in active' }}" id="default">
                     <div class="row clearfix">
                        <div class="col-md-2">
                           <div class="form-group">
                              <div class="form-line">
                                 <label for="port">Port (*)</label>
                                 <input type="number" min="1" max="65535" class="form-control" id="port" name="port" value="{{ $server->port }}" required>
                                 <span class="text-danger">
                                    @error('port')
                                       {{ $message }}
                                    @enderror
                                 </span>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-2">
                           <div class="form-group">
                              <label for="protocol">Protocol (*)</label>
                              <select class="form-control" id="protocol" name="protocol" required>
                                 <option value="udp" {{ $server->protocol === 'udp' ? 'selected' : '' }}>UDP</option>
                                 <option value="tcp" {{ $server->protocol === 'tcp' ? 'selected' : '' }}>TCP</option>
                              </select>
                              <span class="text-danger">
                                 @error('protocol')
                                    {{ $message }}
                                 @enderror
                              </span>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div role="tabpanel" class="tab-pane fade {{ $server->use_file || $errors->has('ovpn_file') ? 'in active' : '' }}" id="custom">
                     <div id="upload_file_container">
                        <label for="ovpn_file">Custom ovpn file (*)</label>
                        <input type="file" class="form-control" id="ovpn_file" name="ovpn_file" accept=".ovpn" {{ $server->use_file ? 'required' : '' }}>
                        <span class="text-danger">
                           @error('ovpn_file')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
            @elseif ($server->use_file)
               <input type="hidden" name="use_file" value="1">
               <ul class="nav nav-tabs tab-nav-right" role="tablist">
                  <li role="presentation" class="active">
                     <a href="#custom" data-toggle="tab">Use custom ovpn file</a>
                  </li>
               </ul>
               <div class="tab-content">
                  <div role="tabpanel" class="tab-pane active" id="custom">
                     <p>Using custom ovpn file for this server. <a target="_blank" href="{{ route('servers.download', ['id' => $server->id, 'type' => 'uploaded']) }}">Click to open file</a>.</p>
                  </div>
               </div>
            @else
               <input type="hidden" name="use_file" value="0">
               <ul class="nav nav-tabs tab-nav-right" role="tablist">
                  <li role="presentation" class="active"><a href="#default" data-toggle="tab">Using default config</a></li>
               </ul>
               <div class="tab-content">
                  <div role="tabpanel" class="tab-pane fade in active" id="default">
                     <div class="row clearfix">
                        <div class="col-md-2">
                           <div class="form-group">
                              <div class="form-line">
                                 <label for="port">Port (*)</label>
                                 <input type="number" min="1" max="65535" class="form-control" id="port" name="port" value="{{ $server->port }}" required>
                                 <span class="text-danger">
                                    @error('port')
                                       {{ $message }}
                                    @enderror
                                 </span>
                              </div>
                           </div>
                        </div>
                        <div class="col-md-2">
                           <div class="form-group">
                              <label for="protocol">Protocol (*)</label>
                              <select class="form-control" id="protocol" name="protocol" required>
                                 <option value="udp" {{ $server->protocol === 'udp' ? 'selected' : '' }}>UDP</option>
                                 <option value="tcp" {{ $server->protocol === 'tcp' ? 'selected' : '' }}>TCP</option>
                              </select>
                              <span class="text-danger">
                                 @error('protocol')
                                    {{ $message }}
                                 @enderror
                              </span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            @endif
         </div>

         <div class="header">
            <h2 class="card-inside-title">Server's additional info</h2>
         </div>
         <div class="body">
            <div class="row clearfix">
               <div class="col-md-3">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="service_provider_link">Service provider link</label>
                        <input type="url" list="links" class="form-control" id="service_provider_link" name="service_provider_link" value="{{ $server->service_provider_link ? $server->service_provider_link : '' }}">
                        <datalist id="links">
                           @foreach ($links as $link)
                              <option value="{{ $link->service_provider_link }}">
                           @endforeach
                        </datalist>
                        <span class="text-danger">
                           @error('service_provider_link')
                              {{ $message }}
                           @enderror
                        </span>
                     </div>
                  </div>
               </div>
               <div class="col-md-9">
                  <div class="form-group form-float">
                     <div class="form-line">
                        <label for="notes">Notes</label>
                        <textarea id="notes" name="notes" rows="5" class="form-control no-resize" aria-required="true">{{ $server->notes }}</textarea>
                     </div>
                  </div>
               </div>
            </div>

            <button type="submit" name="submit" value="" class="btn bg-green waves-effect"><i class="material-icons">save</i><span> Save Changes</span></button>
            @if ($server->id == -1)
               <button type="submit" name="submit" value="new" class="btn bg-teal waves-effect"><i class="material-icons">save</i><span> Save then add new one</span></button>
            @endif
         </div>
      </form>
   </div>
@endsection
