@extends('admin.template')

@push('scripts')
   <script type="text/javascript">
      $('#copy_code').on('click', function() {
         copyContent($('#android_code').text())
         toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": false,
            "positionClass": "toast-top-right",
            "preventDuplicates": true,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "2000",
            "timeOut": "3500",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
         }
         toastr["success"]("Code copied successfully to your clipboard", "Success");
      });

      $('#confirm_delete').on('click', function() {
         $.ajax({
            url: "{!! route('config.delete_android') !!}",
            type: 'DELETE',
            success: function(response) {
               window.location.reload();
            }
         });
      });
   </script>
@endpush

@section('content')
   <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
         <div class="card">
            <div class="header">
               <h2>VPN install files</h2>

               <div class="body">
                  <div class="row">
                     <div class="col-md-10">
                        <span>You can download VPN install script here to use it out of admin panel.</span>
                     </div>
                     <div class="col-md-2" id="download_div" style="box-shadow: none;">
                        <a type="button" href="{{ route('config.download_install') }}" class="btn bg-teal btn-block btn-lg waves-effect"><i class="material-icons">file_download</i> <span> DOWNLOAD FILE</span></a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
         <div class="card">
            <div class="header">
               <h2>Android Config file</h2>
            </div>
            <div class="body">
               @if ($android_config == '')
                  File has been deleted or does not exist.
               @else
                  <div class="row">
                     <div class="col-md-10">
                        For Android app to work, you need to paste below code into your Android source code (source/android_ovpn/app/src/main/java/com/dzboot/constants/Constants.kt).<br>
                        Once done, it is recomanded that delete this code from your Admin Panel and save it just on your computer.
                     </div>
                     <div class="col-md-2 btn-group-vertical" style="box-shadow: none;">
                        <button id="copy_code" type="button" class="btn btn-success waves-effect">COPY</button>
                        <button id="delete_code" type="button" class="btn btn-danger waves-effect" data-toggle="modal" data-target="#delete_android_modal">DELETE</button>
                     </div>
                  </div>

                  <pre>
                    <code id="android_code" class="language-css">{{ $android_config }}</code>
                </pre>
                  <p>&nbsp;</p>
               @endif
            </div>
         </div>
      </div>
   </div>

   <!-- Delete android config modal -->
   <div class="modal fade" id="delete_android_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
         <div class="modal-content">
            <div class="modal-header">
               <h4 class="modal-title" id="myModalLabel">Delete android config confirmation <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">Deleting this configuration is irreversible. Please make sure you copied this configuration to your Android source code before deleting it.</div>
            <div class="modal-footer">
               <div class="btn-group" role="group">
                  <button type="button" class="btn bg-grey waves-effect" id="cancel_delete" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                  <button type="button" class="btn bg-pink waves-effect" id="confirm_delete" data-dismiss="modal"><i class="material-icons">warning</i> <span> DELETE</span></button>
               </div>
            </div>
         </div>
      </div>
   </div>
@endsection
