@extends('admin.template')

@push('scripts')
<!-- Flot Chart Plugins Js -->
<script src="/js/flot-charts/jquery.flot.js"></script>
<script src="/js/flot-charts/jquery.flot.resize.js"></script>
<script src="/js/flot-charts/jquery.flot.pie.js"></script>
<script src="/js/flot-charts/jquery.flot.categories.js"></script>
<script src="/js/flot-charts/jquery.flot.time.js"></script>

<script type="text/javascript">
    $.plot('#pie_chart', {!!$data['truncated_data']!!}, {
        series: {
            pie: {
                show: true,
                radius: 1,
                label: {
                    show: true,
                    radius: 3 / 4,
                    formatter: labelFormatter,
                    background: {
                        opacity: 0.5
                    }
                }
            }
        },
        legend: {
            show: false
        }
    });

    function labelFormatter(label, series) {
        return '<div style="font-size:8pt; text-align:center; padding:2px; color:white;">' + label + '<br/>' + Math.round(series.percent) + '%</div>';
    }
</script>
@endpush

@section('content')

<!-- Widgets -->
<div class="row clearfix">
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <a href="{{route('servers.all')}}" style="text-decoration: none;">
            <div class="info-box bg-cyan hover-expand-effect" style="cursor: pointer;">
                <div class="icon">
                    <i class="material-icons">vpn_lock</i>
                </div>
                <div class="content">
                    <div class="text">Servers</div>
                    <div class="number count-to" data-from="0" data-to="{{$data['servers']->enabled}}" data-speed="1000" data-fresh-interval="20">{{$data['servers']->enabled}}/{{$data['servers']->total}}</div>
                </div>
            </div>
        </a>
    </div>
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-light-green hover-expand-effect">
            <div class="icon">
                <i class="material-icons">devices</i>
            </div>
            <div class="content">
                <div class="text">Connected Devices</div>
                <div class="number count-to" data-from="0" data-to="{{$data['connected']}}" data-speed="1000" data-fresh-interval="20">{{$data['connected']}}</div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
        <div class="info-box bg-pink hover-expand-effect" style="cursor: pointer;">
            <div class="icon">
                <i class="material-icons">update</i>
            </div>
            <div class="content">
                <div class="text">Last Update</div>
                <div class="text">{{$data['last_update']}}</div>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <!-- Task Info -->
    <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
        <div class="card">
            <div class="header">
                <h2>CONNECT BY COUNTRY</h2>
            </div>
            <div class="body">
                <div class="table-responsive">
                    <table class="table table-hover dashboard-task-infos">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Country</th>
                                <th>Total Connects</th>
                                <th>%</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data['country_stats'] as $stat)
                                <tr>
                                    <td>{{$index++}}</td>
                                    <td>
                                        <div data-toggle="tooltip" title="{{strtoupper($stat->country_code)}}" data-placement="bottom" >
                                            <img class="" style="max-height: 35px; max-width: 35px;" src="/images/flags/ic_flag_{{$stat->country_code}}.png" alt="{{$stat->country_code}}" >
                                            <span>{{Locale::getDisplayRegion("-$stat->country_code", 'en')}}</span>
                                        </div>
                                    </td>
                                    <td>{{$stat->connect_count}}</td>
                                    <td>{{$stat->percent}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- #END# Task Info -->
    <!-- Browser Usage -->
    <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
        <div class="card">
            <div class="header">
                <h2>MOST CONNECTED COUNTRIES</h2>
            </div>
            <div class="body">
            <div id="pie_chart" style="height: 370px; width: 100%;"></div>
            </div>
        </div>
    </div>
    <!-- #END# Browser Usage -->
</div>
<!-- #END# Widgets -->

@endsection
