@extends('admin.template')

@push('scripts')
   <script>
      $(function() {

        toastr.options = {
                tapToDismiss: true,
                toastClass: 'toast',
                containerId: 'toast-container',
                debug: false,
                fadeIn: 300,
                fadeOut: 500,
                extendedTimeOut: 1000,
                iconClass: 'toast-info',
                positionClass: 'toast-top-right',
                timeOut: 3000,
                titleClass: 'toast-title',
                messageClass: 'toast-message'
            }

         $('#add-notification').click(function() {
            location.href="{{route('notifications.create')}}";
         });

        var duplicateUrl = null;
        var bulkDeleteUrl = null;
        var bulkDeleteDebug = "{{route('notifications.delete', 'debug')}}";
        var bulkDeleteAll = "{{route('notifications.delete', 'all')}}";

        $('.btn-duplicate').click(function() {
            duplicateUrl = $(this).data('url');
        });

        $('#cancel_duplicate').click(function() {
            duplicateUrl = null;
        });

        $('#delete-all').click(function() {
            bulkDeleteUrl = bulkDeleteAll;
        });

        $('#delete-debug').click(function() {
            bulkDeleteUrl = bulkDeleteDebug;
        });

        $('#duplicate').click(function() {
            if (duplicateUrl) {
                $.ajax({
                    url: duplicateUrl,
                    type: 'GET',
                    success: function(result) {
                        if (result == 1)
                            window.location.reload();
                    }
                });
            }
        });

        $('.delete').click(function() {
            $.ajax({
                url: $(this).data('url'),
                type: 'DELETE',
                success: function(result) {
                    if (result == 1)
                    window.location.reload();
                }
            });
        });

        $('#delete').click(function() {
            if (bulkDeleteUrl) {
                $.ajax({
                    url: bulkDeleteUrl,
                    type: 'DELETE',
                    success: function(result) {
                        if (result == 1)
                            window.location.reload();
                    }
                });
            }
        });
      });
   </script>

   @if($successMessage)
        <script>
            toastr.success('{{$successMessage}}');
        </script>
   @endif
@endpush

@section('content')
<div class="row">
   <button type="button" id="delete-all" class="btn btn-delete btn-warning btn-rounded pull-right" data-toggle="modal" data-target="#delete_modal" style="margin: 10px;"><i class="material-icons">delete_forever</i><span>Delete All</span></button>
   <button type="button" id="delete-debug" class="btn btn-delete btn-warning btn-rounded pull-right" data-toggle="modal" data-target="#delete_modal" style="margin: 10px;"><i class="material-icons">delete_forever</i><span>Delete Debug</span></button>
   <button type="button" id="add-notification" class="btn bg-light-blue waves-effect pull-right" style="margin: 10px;"><i class="material-icons">add_box</i><span>New Notification</span></button>
</div>

<div class="card">
      <div class="body">
         <div class="row clearfix">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-bottom: 0 !important;">
                <div class="table-responsive">
                    <table class="table table-striped" id="sort">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Topic</th>
                            <th>Title</th>
                            <th>Sent at</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($notifications as $notification)
                            <tr>
                                <td id="id">{{$notification->id}}</td>
                                <td>{{$notification->topic}}</td>
                                <td>{{$notification->title}}</td>
                                <td>{{$notification->created_at}}</td>
                                <td>
                                    <button type="button" data-url="{{ route('notifications.duplicate', $notification->id) }}" class="btn btn-duplicate bg-cyan btn-rounded icon-only" data-toggle="modal" data-target="#duplicate_modal"><i class="material-icons">content_copy</i></button>
                                    <button type="button" data-url="{{ route('notifications.delete', $notification->id) }}" class="delete btn btn-delete btn-warning btn-rounded icon-only"><i class="material-icons">delete_forever</i></button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            {{$notifications->links('defaults.pagination')}}
        </div>
      </div>
</div>

<!-- Duplicate modal -->
<div class="modal fade" id="duplicate_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Duplicate Notification <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">The same notification will be sent again. Do you wish to continue?</div>
            <div class="modal-footer">
                <div class="btn-group" role="group">
                    <button type="button" class="btn bg-grey waves-effect" id="cancel_duplicate" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                    <button type="button" class="btn bg-green waves-effect" id="duplicate"><i class="material-icons">check</i> <span> CONTINUE</span></button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Duplicate modal -->
<div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Delete Notifications <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">Notifications will be deleted. Do you wish to continue?</div>
            <div class="modal-footer">
                <div class="btn-group" role="group">
                    <button type="button" class="btn bg-grey waves-effect" id="cancel_delete" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                    <button type="button" class="btn bg-green waves-effect" id="delete"><i class="material-icons">check</i> <span> CONTINUE</span></button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
