@extends('admin.template')

@push('scripts')
   <script>
        $(function() {
            $('.form-line').each(function () {$(this).removeClass('focused')});
        });
   </script>
@endpush

@section('content')

<div class="row clearfix">
   <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
      <div class="card">
         <div class="header">
               <h2>Admin Info</h2>
         </div>
         <div class="body">
            <form method="post" action="{{ route('profile.edit') }}">
               @csrf
               <label for="name">Name</label>
               <div class="form-group">
                  <div class="form-line">
                     <input type="text" class="form-control" id="name" name="name" value="{{ $user->name }}" required>
                     <span class="text-danger">@error('name'){{$message}}@enderror</span>
                  </div>
               </div>
               <label for="email">Email</label>
               <div class="form-group">
                  <div class="form-line">
                     <input type="text" class="form-control" id="email" name="email" value="{{ $user->email }}" required>
                     <span class="text-danger">@error('email'){{$message}}@enderror</span>
                  </div>
               </div>

               <button type="submit" class="btn bg-green waves-effect"><i class="material-icons">save</i><span>Save Changes</span></button>
            </form>
         </div>
      </div>
   </div>
   <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
      <div class="card">
         <div class="header">
               <h2>Security Info</h2>
         </div>
         <div class="body">
            <form method="post" action="{{ route('security.edit') }}">
               @csrf
               <label for="password">Password</label>
               <div class="form-group">
                  <div class="form-line">
                     <input type="password" class="form-control" id="password" name="password" required>
                     <span class="text-danger">@error('password'){{$message}}@enderror</span>
                  </div>
               </div>
               <label for="password_confirmation">Confirm Password</label>
               <div class="form-group">
                  <div class="form-line">
                     <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                     <span class="text-danger">@error('email'){{$message}}@enderror</span>
                  </div>
               </div>

               <button type="submit" class="btn bg-green waves-effect"><i class="material-icons">save</i><span>Save Changes</span></button>
            </form>
         </div>
      </div>
   </div>
</div>
@endsection
