@extends('admin.template')

@push('scripts')
   <script>
      $(function() {
         var fixHelperModified = function(e, tr) {
               var $originals = tr.children();
               var $helper = tr.clone();
               $helper.children().each(function(index) {
                  $(this).width($originals.eq(index).width())
               });
               return $helper;
            },
            updateIndex = function(e, ui) {
               // $('td.index', ui.item.parent()).each(function (i) {
               //    $(this).html(i + 1);
               // });
            };

         $("#sort tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
         }).disableSelection();

         $('#save').click(function() {
            var order = [];
            $('#sort tbody tr').each(function() {
               order.push($(this).find('#id').text());
            });
            $.ajax({
               url: "{{ route('servers.reorder') }}",
               type: 'POST',
               data: {
                  order: order
               },
               success: function(result) {
                  if (result == 1)
                     window.location.reload();
               }
            });
         });

         $('#add-server').click(function() {
            location.href = "{{ route('servers.add') }}";
         });

         var deleteUrl = null;
         var resetUrl = null;

         $('.btn-delete').click(function() {
            deleteUrl = $(this).data('url');
         });

         $('.btn-reset-devices').click(function() {
            resetUrl = $(this).data('url');
         });

         $('#cancel_delete').click(function() {
            deleteUrl = null;
         });

         $('#cancel_reset_devices').click(function() {
            resetUrl = null;
         });

         $('#delete').click(function() {
            if (deleteUrl) {
               $.ajax({
                  url: deleteUrl,
                  type: 'DELETE',
                  success: function(result) {
                     if (result == 1)
                        window.location.reload();
                  }
               });
            }
         });

         $('#reset_devices').click(function() {
            if (resetUrl) {
               $.ajax({
                  url: resetUrl,
                  type: 'POST',
                  success: function(result) {
                     if (result == 1)
                        window.location.reload();
                  }
               });
            }
         });

         function ping(id, ip) {
            $.ajax({
               url: "{{ route('servers.ping') }}",
               type: 'GET',
               data: {
                  ip: ip
               },
               success: function(result) {
                  $('#loading' + id).addClass('hidden');
                  if (result) {
                     $('#available' + id).removeClass('hidden');
                  } else {
                     $('#unavailable' + id).removeClass('hidden');
                  }
               },
               error: function(xhr, ajaxOptions, thrownError) {
                  $('#loading' + id).addClass('hidden');
                  $('#unavailable' + id).removeClass('hidden');
               }
            });
         }

         $('.retry-ping').on('click', function() {
            var id = $(this).data('id');
            $('#loading' + id).removeClass('hidden');
            $('#unavailable' + id).addClass('hidden');
            ping(id, $(this).data('ip'));
         });

         var servers = @json($servers);
         servers.forEach(function(server) {
            ping(server.id, server.ip);
         });

         $('.copy-content').on('click', function() {
            copyContent($(this).text());
         });
      });
   </script>

   @if ($successMessage)
      <script>
         toastr.options = {
            tapToDismiss: true,
            toastClass: 'toast',
            containerId: 'toast-container',
            debug: false,
            fadeIn: 300,
            fadeOut: 500,
            extendedTimeOut: 1000,
            iconClass: 'toast-info',
            positionClass: 'toast-top-right',
            timeOut: 3000,
            titleClass: 'toast-title',
            messageClass: 'toast-message'
         }

         toastr.success('{{ $successMessage }}');
      </script>
   @endif
@endpush

@section('content')
   <div class="row">
      <button type="button" id="save" class="btn bg-green waves-effect pull-right" style="margin: 10px;"><i class="material-icons">save</i><span>Save Changes</span></button>
      <button type="button" id="add-server" class="btn bg-light-blue waves-effect pull-right" style="margin: 10px;"><i class="material-icons">add_box</i><span>Add Server</span></button>
   </div>

   <div class="row clearfix">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
         <div class="card">
            <div class="body table-responsive">
               <table class="table table-striped" id="sort">
                  <thead>
                     <tr>
                        <th>Order</th>
                        <th>#</th>
                        <th>Country</th>
                        <th>City</th>
                        <th>IP</th>
                        <th>Protocole (Port)</th>
                        <th>Access</th>
                        <th>Capacity</th>
                        @if (check_exec())
                           <th>Availability</th>
                        @endif
                        <th>Actions</th>
                     </tr>
                  </thead>
                  <tbody>
                     @foreach ($servers as $server)
                        <tr @if (!$server->is_enabled) class="danger" @endif>
                           <td><a class="btn btn-default btn-rounded icon-only"><i class="material-icons">view_headline</i></a></td>
                           <td id="id">{{ $server->id }}</td>
                           <td>
                              <div data-toggle="tooltip" title="{{ strtoupper($server->country_code) }}" data-placement="bottom">
                                 <img class="" style="max-height: 35px; max-width: 35px;" src="/images/flags/ic_flag_{{ $server->country_code }}.png" alt="{{ $server->country_code }}">
                                 <span>{{ Locale::getDisplayRegion("-$server->country_code", 'en') }}</span>
                              </div>
                           </td>
                           <td>{{ "{$server->city}" }}</td>
                           <td><a style="cursor: pointer;" class="copy-content" data-toggle="tooltip" title="Click to copy IP" data-placement="bottom">{{ $server->ip }}</a></td>
                           <td>
                              @if ($server->use_file)
                                 <a target="_blank" href="{{ route('servers.download', ['id' => $server->id, 'type' => 'uploaded']) }}">Custom file</a>
                              @else
                                 {{ "{$server->protocol} ({$server->port})" }}
                              @endif
                           </td>
                           <td>{{ $server->is_free ? 'Free' : 'Premium' }}</td>
                           <td>{{ "{$server->connected_devices}/{$server->capacity}" }}</td>
                           @if (check_exec())
                              <td>
                                 <div id="loading{{ $server->id }}" class="loading"></div>
                                 <i id="available{{ $server->id }}" class="material-icons hidden" style="color:chartreuse; font-size: 30px;">check_circle</i>
                                 <a data-toggle="tooltip" title="Can not reach this server. Click to retry." data-placement="bottom" id="unavailable{{ $server->id }}" data-id="{{ $server->id }}" data-ip="{{ $server->ip }}" class="retry-ping hidden" style="cursor: pointer;">
                                    <i class="material-icons" style="color:crimson; font-size: 30px;">cancel</i>
                                 </a>
                              </td>
                           @endif
                           <td>
                              @if ($server->service_provider_link)
                                 <a data-toggle="tooltip" title="Go to server provider page" data-placement="bottom" href="{{ $server->service_provider_link }}" target="_blank" class="btn btn-primary btn-rounded icon-only"><i class="material-icons">open_in_new</i></a>
                              @endif
                              <a href="{{ route('servers.show', $server->id) }}" class="btn btn-success btn-rounded icon-only"><i class="material-icons">mode_edit</i></a>
                              <button type="button" data-url="{{ route('servers.delete', $server->id) }}" class="btn btn-delete btn-warning btn-rounded icon-only" data-toggle="modal" data-target="#delete_modal"><i class="material-icons">delete_forever</i></button>
                              <button type="button" data-url="{{ route('servers.reset_devices', $server->id) }}" class="btn btn-reset-devices btn-warning btn-rounded icon-only" data-toggle="modal" data-target="#reset_devices_modal"><i class="material-icons">restore</i></button>
                           </td>
                        </tr>
                     @endforeach
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>

   <!-- Delete modal -->
   <div class="modal fade" id="delete_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
         <div class="modal-content">
            <div class="modal-header">
               <h4 class="modal-title" id="myModalLabel">Delete confirmation <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">Do you really want to delete this server?</div>
            <div class="modal-footer">
               <div class="btn-group" role="group">
                  <button type="button" class="btn bg-grey waves-effect" id="cancel_delete" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                  <button type="button" class="btn bg-pink waves-effect" id="delete"><i class="material-icons">warning</i> <span> DELETE</span></button>
               </div>
            </div>
         </div>
      </div>
   </div>

   <!-- Reset connected devices modal -->
   <div class="modal fade" id="reset_devices_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
         <div class="modal-content">
            <div class="modal-header">
               <h4 class="modal-title" id="myModalLabel">Reset connected devices confirmation <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">Do you really want to reset connected devices this server? This won't disconnect them if they are still connected.</div>
            <div class="modal-footer">
               <div class="btn-group" role="group">
                  <button type="button" class="btn bg-grey waves-effect" id="cancel_reset_devices" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                  <button type="button" class="btn bg-pink waves-effect" id="reset_devices"><i class="material-icons">warning</i> <span> RESET</span></button>
               </div>
            </div>
         </div>
      </div>
   </div>
@endsection
