@extends('admin.template')

@push('scripts')
   <script type="text/javascript">
      $('#confirm_reset').on('click', function() {
         $.ajax({
            url: "{!! route('connectedDevices.resetOldDevices') !!}",
            type: 'DELETE',
            success: function(response) {
               if (response['result']) {
                  toastr.options = {
                     "closeButton": true,
                     "debug": false,
                     "newestOnTop": false,
                     "progressBar": false,
                     "positionClass": "toast-top-right",
                     "preventDuplicates": true,
                     "onclick": null,
                     "showDuration": "300",
                     "hideDuration": "2000",
                     "timeOut": "3500",
                     "extendedTimeOut": "1000",
                     "showEasing": "swing",
                     "hideEasing": "linear",
                     "showMethod": "fadeIn",
                     "hideMethod": "fadeOut"
                  }
                  toastr["success"](response['count'] + " connected devices has been reset.", "Success");
               }
            }
         });
      });
   </script>
@endpush

@section('content')
   <div class="row clearfix card">
      <div class="body">
         <h2 class="card-inside-title">App Settings</h2>
         <form id="app_settings" method="POST" class="p-20">
            @csrf

            <input type="hidden" name="settings_type" value="app_settings">
            <div class="row clearfix">
               <div class="col-md-2">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="version">App version code</label>
                        <input type='number' class="form-control" name="version" id="version" min="0" value="{{ $data['version'] }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="older_than_days">Reset connected devices olders than (days)</label>
                        <input type='number' class="form-control" name="older_than_days" id="older_than_days" min="0" value="{{ isset($data['older_than_days']) ? $data['older_than_days'] : '1' }}">
                     </div>
                  </div>
               </div>
            </div>
            <div class="row clearfix">
               <div>
                  <input type="checkbox" id="allow_duplicate_ips" name="allow_duplicate_ips" class="filled-in" {{ (isset($data['allow_duplicate_ips']) ? $data['allow_duplicate_ips'] : '1') == 1 ? 'checked' : '' }}>
                  <label for="allow_duplicate_ips">Allow duplicate IP addresses</label>
               </div>
            </div>
            <div class="row clearfix">
               <div>
                  <input type="checkbox" id="track_connections" name="track_connections" class="filled-in" {{ (isset($data['track_connections']) ? $data['track_connections'] : '0') == 1 ? 'checked' : '' }}>
                  <label for="track_connections">Track users connections (enabling this may lead to slow performance or even server blockage, use at your own risk)</label>
               </div>
            </div>
            <div class="row">
               <div class="col-md-12">
                  <div class="btn-group pull-right mt-10" role="group">
                     <button type="submit" class="btn bg-green waves-effect"><i class="material-icons">save</i><span>Save Changes</span></button>
                  </div>
               </div>
            </div>
         </form>

         <h2 class="card-inside-title">Reset old connected devices</h2>
         <div class="row clearfix">
            <div class="col-md-12">
               <div class="panel">
                  <div class="panel-body">
                     <p>In some cases database is not informed of disconnected devices. To mark old devices as disconnected, click on the Reset button below.</p>
                     <div class="text-center">
                        <button type="button" class="btn btn-primary btn-wide" id="confirme_reset" data-toggle="modal" data-target="#reset_modal">Reset</button>
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <h2 class="card-inside-title">AdMob Settings</h2>
         <span>Leave field empty if you want to disable it</span>
         <form id="admob_settings" method="POST" class="p-20">
            @csrf

            <input type="hidden" name="settings_type" value="app_settings">
            <div class="row clearfix">
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_appopen_id">AdMob AppOpen ad ID</label>
                        <input type='text' class="form-control" name="admob_appopen_id" id="admob_appopen_id" value="{{ isset($data['admob_appopen_id']) ? $data['admob_appopen_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_allowed_apps_banner_id">AdMob Allowed Apps Banner ad ID</label>
                        <input type='text' class="form-control" name="admob_allowed_apps_banner_id" id="admob_allowed_apps_banner_id" value="{{ isset($data['admob_allowed_apps_banner_id']) ? $data['admob_allowed_apps_banner_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_servers_banner_id">AdMob Servers Banner ad ID</label>
                        <input type='text' class="form-control" name="admob_servers_banner_id" id="admob_servers_banner_id" value="{{ isset($data['admob_servers_banner_id']) ? $data['admob_servers_banner_id'] : '' }}">
                     </div>
                  </div>
               </div>
            </div>

            <div class="row clearfix">
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_connect_inter_id">AdMob Connect Interstitial ad ID</label>
                        <input type='text' class="form-control" name="admob_connect_inter_id" id="admob_connect_inter_id" value="{{ isset($data['admob_connect_inter_id']) ? $data['admob_connect_inter_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_inter_id">AdMob Navigate Interstitial ad ID</label>
                        <input type='text' class="form-control" name="admob_inter_id" id="admob_inter_id" value="{{ isset($data['admob_inter_id']) ? $data['admob_inter_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_more_time_inter_id">AdMob More Time Interstitial ad ID</label>
                        <input type='text' class="form-control" name="admob_more_time_inter_id" id="admob_more_time_inter_id" value="{{ isset($data['admob_more_time_inter_id']) ? $data['admob_more_time_inter_id'] : '' }}">
                     </div>
                  </div>
               </div>
            </div>

            <div class="row clearfix">
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_more_time_reward_inter_id">AdMob Rewarded Interstitial ad ID</label>
                        <input type='text' class="form-control" name="admob_more_time_reward_inter_id" id="admob_more_time_reward_inter_id" value="{{ isset($data['admob_more_time_reward_inter_id']) ? $data['admob_more_time_reward_inter_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_more_time_reward_id">AdMob Reward ad ID</label>
                        <input type='text' class="form-control" name="admob_more_time_reward_id" id="admob_more_time_reward_id" value="{{ isset($data['admob_more_time_reward_id']) ? $data['admob_more_time_reward_id'] : '' }}">
                     </div>
                  </div>
               </div>
               <div class="col-md-4">
                  <div class="form-group">
                     <div class="form-line">
                        <label for="admob_native_id">AdMob Native ad ID</label>
                        <input type='text' class="form-control" name="admob_native_id" id="admob_native_id" value="{{ isset($data['admob_native_id']) ? $data['admob_native_id'] : '' }}">
                     </div>
                  </div>
               </div>
            </div>

            <div class="row">
               <div class="col-md-12">
                  <div class="btn-group pull-right mt-10" role="group">
                     <button type="submit" class="btn bg-green waves-effect"><i class="material-icons">save</i><span>Save Changes</span></button>
                  </div>
               </div>
            </div>
         </form>
      </div>
   </div>

   <!-- Reset modal -->
   <div class="modal fade" id="reset_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
         <div class="modal-content">
            <div class="modal-header">
               <h4 class="modal-title" id="myModalLabel">Reset confirmation <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">X</span></button></h4>
            </div>
            <div class="modal-body">Do you really want to reset connected devices older than {{ $data['older_than_days'] }} days?</div>
            <div class="modal-footer">
               <div class="btn-group" role="group">
                  <button type="button" class="btn bg-grey waves-effect" id="cancel_reset" data-dismiss="modal"><i class="material-icons">close</i> <span> CANCEL</span></button>
                  <button type="button" class="btn bg-pink waves-effect" id="confirm_reset" data-dismiss="modal"><i class="material-icons">warning</i> <span> RESET</span></button>
               </div>
            </div>
         </div>
      </div>
   </div>
@endsection
