<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="UTF-8">
   <meta http-equiv="X-UA-Compatible" content="IE=Edge">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="csrf-token" content="{{ csrf_token() }}" />

   <title><?php echo config('app.name'); ?> Dashboard</title>
   <!-- Favicon-->
   <link rel="icon" href="/images/logo.png" type="image/x-icon">

   <!-- Google Fonts -->
   <link href="https://fonts.googleapis.com/css?family=Roboto:400,700&subset=latin,cyrillic-ext" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css">

   <!-- ========== COMMON STYLES ========== -->
   <link rel="stylesheet" href="/css/bootstrap/bootstrap.min.css">
   <link rel="stylesheet" href="/css/bootstrap/bootstrap-select.min.css">
   <link rel="stylesheet" href="/css/bootstrap/bootstrap-select-country.min.css">
   <link rel="stylesheet" href="/css/font-awsome/font-awesome.min.css" media="screen">
   <link rel="stylesheet" href="/css/animate-css/animate.min.css" media="screen">
   <link rel="stylesheet" href="/css/lobipanel/lobipanel.min.css" media="screen">
   <link rel="stylesheet" href="/css/toastr/toastr.min.css" media="screen">

   <!-- ========== THEME CSS ========== -->
   <link rel="stylesheet" href="/css/theme-orange.min.css" />
   <link rel="stylesheet" href="/css/materialize.css" media="screen">
   <link rel="stylesheet" href="/css/style.css" media="screen">
   <link rel="stylesheet" href="/css/main.css" media="screen">
</head>

<body class="theme-orange">
   <!-- Page Loader -->
   <div class="page-loader-wrapper">
      <div class="loader">
         <div class="preloader">
            <div class="spinner-layer pl-red">
               <div class="circle-clipper left">
                  <div class="circle"></div>
               </div>
               <div class="circle-clipper right">
                  <div class="circle"></div>
               </div>
            </div>
         </div>
         <p>Loading...</p>
      </div>
   </div>
   <!-- #END# Page Loader -->

   <!-- Overlay For Sidebars -->
   <div class="overlay"></div>
   <!-- #END# Overlay For Sidebars -->

   <!-- Top Bar -->
   <nav class="navbar">
      <div class="container-fluid">
         <div class="navbar-header">
            <a href="javascript:void(0);" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse" aria-expanded="false"></a>
            <a href="javascript:void(0);" class="bars"></a>
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
               <img src="/images/logo.png" alt="{{ config('app.name') }}" style="height: 26px; display: inline-block;">
               {{ config('app.name') }}
            </a>
         </div>
         <div class="collapse navbar-collapse" id="navbar-collapse">
            <ul class="nav navbar-nav navbar-right">
               <!-- Notifications -->
               <li class="dropdown hidden">
                  <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button">
                     <i class="material-icons">notifications</i>
                     <span class="label-count">7</span>
                  </a>
                  <ul class="dropdown-menu">
                     <li class="header">NOTIFICATIONS</li>
                     <li class="body"></li>
                     <li class="footer">
                        <a href="javascript:void(0);">View All Notifications</a>
                     </li>
                  </ul>
               </li>
               <!-- #END# Notifications -->
               <!-- User -->
               <li class="dropdown">
                  <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button">
                     {{ Auth::user()->name }} <span class="caret"></span>
                  </a>
                  <ul class="dropdown-menu">
                     <li><a href="{{ route('profile') }}"><i class="material-icons">person</i> Account Settings</a></li>
                     <li role="separator" class="divider"></li>
                     <li>
                        <a class="color-danger text-center" href="{{ route('logout') }}" onclick="
                                    event.preventDefault();
                                    document.getElementById('logout-form').submit();
                                    "><i
                              class="material-icons">power_settings_new</i> Logout
                        </a>
                     </li>
                  </ul>
                  <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                     @csrf
                  </form>
               </li>
               <!-- #END# User -->
            </ul>
         </div>
      </div>
   </nav>

   <!-- #Top Bar -->
   <section>
      <!-- Left Sidebar -->
      <aside id="leftsidebar" class="sidebar">
         <!-- Menu -->
         <div class="menu">
            <ul class="list">
               <li class="{{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                  <a href="{{ route('admin.dashboard') }}">
                     <i class="material-icons">home</i>
                     <span>Dashboard</span>
                  </a>
               </li>
               <li>
                  <a href="javascript:void(0);" class="menu-toggle {{ request()->routeIs('servers.*') ? 'toggled' : '' }}">
                     <i class="material-icons">vpn_lock</i>
                     <span>Servers</span>
                  </a>
                  <ul class="ml-menu">
                     <li class="{{ request()->routeIs('servers.all') ? 'active' : '' }}">
                        <a href="{{ route('servers.all') }}"> <span>All Servers</span></a>
                     </li>
                     <li class="{{ request()->routeIs('servers.add') ? 'active' : '' }}">
                        <a href="{{ route('servers.add') }}"> <span>Add VPN Server</span></a>
                     </li>
                  </ul>
               </li>
               <li>
                  <a href="javascript:void(0);" class="menu-toggle {{ request()->routeIs('notifications.create') || request()->routeIs('notifications') ? 'toggled' : '' }}">
                     <i class="material-icons">notifications</i>
                     <span>Push Notifications</span>
                  </a>
                  <ul class="ml-menu">
                     <li class="{{ request()->routeIs('notifications') ? 'active' : '' }}">
                        <a href="{{ route('notifications') }}"> <span>All Notifications</span></a>
                     </li>
                     <li class="{{ request()->routeIs('notifications.create') ? 'active' : '' }}">
                        <a href="{{ route('notifications.create') }}"> <span>Add Notification</span></a>
                     </li>
                  </ul>
               </li>
               <li class="{{ request()->routeIs('admin.config') ? 'active' : '' }}">
                  <a href="{{ route('admin.config') }}">
                     <i class="material-icons">android</i>
                     <span>Configuration</span>
                  </a>
               </li>
               <li class="{{ request()->routeIs('admin.settings') ? 'active' : '' }}">
                  <a href="{{ route('admin.settings') }}">
                     <i class="material-icons">settings</i>
                     <span>Settings</span>
                  </a>
               </li>
            </ul>
         </div>
         <!-- #Menu -->
         <!-- Footer -->
         <div class="legal">
            <div class="copyright">
               &copy; 2023 <a href="javascript:void(0);">OVPN Control Panel</a>
            </div>
            <div class="version"><b>Version: </b> {{ env('APP_VERSION') }}</div>
         </div>
         <!-- #Footer -->
      </aside>
      <!-- #END# Left Sidebar -->
   </section>

   <section class="content">
      <div class="container-fluid">
         <div class="block-header">
            <h2>{{ $title }}</h2>
         </div>

         @yield('content')
      </div>
   </section>

   <!-- ========== COMMON JS FILES ========== -->
   <script src="/js/jquery/jquery.min.js"></script>
   <script src="/js/jquery/jquery.slimscroll.js"></script>
   <script src="/js/jquery/jquery.countTo.js"></script>
   <script src="/js/jquery-ui/jquery-ui.min.js"></script>
   <script src="/js/bootstrap/bootstrap.min.js"></script>
   <script src="/js/bootstrap/bootstrap-select.min.js"></script>
   <script src="/js/bootstrap/bootstrap-confirmation.min.js"></script>
   <script src="/js/bootstrap/bootstrap-session-timeout.min.js"></script>
   <script src="/js/bootstrap/bootstrap-switch.min.js"></script>
   <script src="/js/bootstrap/bootstrap-select-country.min.js"></script>
   <script src="/js/bootstrap/jquery.bootstrap-growl.min.js"></script>
   <script src="/js/raphael/raphael.min.js"></script>
   <script src="/js/toastr/toastr.min.js"></script>
   <script src="/js/morrisjs/morris.js"></script>
   <script src="/js/pace/pace.min.js"></script>
   <script src="/js/lobipanel/lobipanel.min.js"></script>

   <!-- Custom Js -->
   <script src="/js/main.min.js"></script>
   <script src="/js/admin.js"></script>

   <script>
      $(function() {
         //setup ajax to avoid CSRF problems
         $.ajaxSetup({
            headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
         });
      });
   </script>

   <!-- ========== ADD custom.js FILE BELOW WITH YOUR CHANGES ========== -->
   @stack('scripts')
</body>

</html>
