<?php

use App\Http\Controllers\Api\v1\ConnectedDevicesController;
use App\Http\Controllers\Api\v1\ServersController;
use App\Http\Controllers\Api\v1\SettingsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

 Route::get('/v1/get-setting', [SettingsController::class, 'get']);
 Route::get('/v1/get-ad-ids', [SettingsController::class, 'getAdIds']);
 Route::get('/v1/list', [ServersController::class, 'all']);
 Route::get('/v1/best', [ServersController::class, 'best']);
 Route::get('/v1/get', [ServersController::class, 'download']);
 Route::get('v1/request-ip', [ConnectedDevicesController::class, 'getIP']);
 Route::post('v1/log-connect', [ConnectedDevicesController::class, 'logConnect']);
 Route::post('v1/log-disconnect', [ConnectedDevicesController::class, 'logDisconnect']);
