<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminsController;
use App\Http\Controllers\Admin\ConfigsController;
use App\Http\Controllers\Admin\ConnectedDevicesController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\NotificationsController;
use App\Http\Controllers\Admin\ServersController;
use App\Http\Controllers\Admin\SettingsController;


Route::get('/', [DashboardController::class, 'index'])->name('admin.dashboard');

Route::get('/profile', [AdminsController::class, 'index'])->name('profile');
Route::post('/edit-profile', [AdminsController::class, 'editProfile'])->name('profile.edit');
Route::post('/edit-security', [AdminsController::class, 'editSecurity'])->name('security.edit');
Route::get('/config', [ConfigsController::class, 'index'])->name('admin.config');
Route::delete('/config/android', [ConfigsController::class, 'deleteAndroidConfig'])->name('config.delete_android');
Route::get('/config/download-install', [ConfigsController::class, 'downloadInstallFiles'])->name('config.download_install');
Route::get('/settings', [SettingsController::class, 'index'])->name('admin.settings');
Route::post('/settings', [SettingsController::class, 'store']);

Route::get('/servers', [ServersController::class, 'index'])->name('servers.all');
Route::get('/servers/add', [ServersController::class, 'add'])->name('servers.add');
Route::post('/servers/add', [ServersController::class, 'store'])->name('servers.store');
Route::get('/servers/ping', [ServersController::class, 'ping'])->name('servers.ping');
Route::get('/servers/download', [ServersController::class, 'download'])->name('servers.download');
Route::get('/servers/{id}', [ServersController::class, 'show'])->name('servers.show');
Route::post('/servers/edit', [ServersController::class, 'edit'])->name('servers.edit');
Route::delete('/servers/{id}', [ServersController::class, 'delete'])->name('servers.delete');
Route::post('/servers/reset/devices/{id}', [ServersController::class, 'resetConnectedDevices'])->name('servers.reset_devices');
Route::post('/servers/reorder', [ServersController::class, 'reorder'])->name('servers.reorder');
Route::get('/console/{id}', [ServersController::class, 'console'])->name('servers.console');

Route::get('/notifications', [NotificationsController::class, 'index'])->name('notifications');
Route::get('/notifications/add', [NotificationsController::class, 'create'])->name('notifications.create');
Route::post('/notifications/add', [NotificationsController::class, 'saveAndSend'])->name('notifications.send');
Route::delete('/notifications/{id}', [NotificationsController::class, 'delete'])->name('notifications.delete');
Route::get('/notifications/duplicate/{id}', [NotificationsController::class, 'duplicate'])->name('notifications.duplicate');

Route::delete('/settings/reset-old-devices', [ConnectedDevicesController::class, 'resetOldDevices'])->name('connectedDevices.resetOldDevices');
